(() => {
  const mainTabs = getNodes("#mainTab .nav-tab");
  const secondaryTabs = getNodes("#secondaryTab .nav-tab");

  const mainPanes = getNodes("#mainTabContent .tab-pane");
  const secondaryPanes = getNodes("#secondaryTabContent .tab-pane");

  function getNodes(query) {
    return document.querySelectorAll(query);
  }

  function disableNodes(nodeList) {
    nodeList.forEach((node) => {
      node.classList.remove("active");
    });
  }

  function enablePane(prefix, tabNumber) {
    const node = document.querySelector(`#${prefix}${tabNumber}`);
    if (node) {
      node.classList.add("active");
    }
  }

  function addTabButtonListeners(tabButtons, prefix, panes) {
    if (!tabButtons?.length) return;

    tabButtons.forEach((node) => {
      node.addEventListener("click", () => {
        disableNodes(tabButtons); // Disable all tabs
        node.classList.add("active"); // Enable current tab

        disableNodes(panes); // Disable all panes
        enablePane(prefix, node.dataset?.tab); // Enable current pane
      });
    });
  }

  addTabButtonListeners(mainTabs, "mainTab", mainPanes);
  addTabButtonListeners(secondaryTabs, "secondaryTab", secondaryPanes);
})();
